#! /bin/sh
#
# Runs in /root, single parameter is package directory ie /root/bin/engine-x.y.z
#
echo "" > /root/first_run_after_install
echo "" > /etc/network/firewall-is-on

#
# Get h/w platform: D11/D12/D22
#
PLATFORM=$(cat /proc/hardwareinfo)
#
# Read 1 character from /dev/lpicp to get the h/w revision (D22 only). Under
# normal circumstances I'd use read -n1 but sadly the BusyBox implementation
# seems to be broken so I do it this way: copy 1 block of 1 byte from the lpicp
# driver to a temp file, then read that to get the h/w revision. This should 
# be A, B, or empty (D11/D12)
#
dd if=/dev/lpicp of=/tmp/rev bs=1 count=1 >/dev/null 2>&1
HWREV=$(cat /tmp/rev)
if [ $PLATFORM == "D22" ]; then
	PLATFORMNAME="D22 Rev"$HWREV
else
	PLATFORMNAME=$PLATFORM
fi
PACKAGE=$1".tar"
echo 'Installing package from '$1' ('$PACKAGE'), destination platform is '$PLATFORMNAME
killall R-Watchdog
#rm /root/LOG/*
cp $1/R-Loader /root/BIN
cp $1/lockdown /root/BIN
cp $1/R-Watchdog /root/BIN
chmod 777 /root/BIN/R-Loader
chmod 777 /root/BIN/lockdown
chmod 777 /root/BIN/R-Watchdog
cp $1/S98watchdog /etc/init.d
chmod 777 /etc/init.d/S98watchdog
#
# Not allowed to do the following in code, so do it now ... root/lock will be
# created if there's a user called R-Access
#
FNAME="/root/lock"
test -f $FNAME && rm $FNAME
(cat /etc/passwd | grep R-Access) && echo "" > $FNAME
#
# Remove symlink to ValvApp library: if it's an actual directory then delete the
# sucker, otherwise just zap the actual symlink
#
if [ -d "/root/CFG" ]; then
	echo 'Removing ValvApp library directory'
	rm -r /root/CFG
fi
if [ -h "/root/CFG" ]; then
	echo 'Removing symlink to ValvApp library directory'
	rm /root/CFG
fi
#
# Create a symlink to the package installation directory
#
test -h /root/PACKAGE && rm /root/PACKAGE
ln -s $1 /root/PACKAGE
#
# Do platform-specific actions here
#
case $PLATFORM in
	'D11'|'D12')
		echo 'Doing platform-specific install tasks for' $PLATFORM
		echo '    Startup scripts'
		cp $1/D12/S97setgpio /etc/init.d
		chmod 777 /etc/init.d/S97setgpio
		cp $1/D12/S99startup /etc/init.d
		chmod 777 /etc/init.d/S99startup
		echo '    Creating ValvApp library symlink'
		ln -s $1/TPL-D12 /root/CFG
		echo '    D12DumpLog'
		cp $1/D12/D12DumpLog $1
		chmod 777 $1/D12DumpLog
		echo '    Bluetooth'
		echo '        R-BtScan'
		cp $1/D12/R-BtScan $1
		chmod 777 $1/R-BtScan
		echo '        support files'
		cp $1/D12/bluetooth/etc/init.d/S60bluetooth /etc/init.d
		chmod 777 /etc/init.d/S60bluetooth
		cp $1/D12/bluetooth/etc/mdev.conf /etc
		cp $1/D12/bluetooth/lib/mdev/bluetooth.sh /lib/mdev
		chmod 777 /lib/mdev/bluetooth.sh
		TGTDIR="/etc/bluetooth/pan"
		if [ ! -d "$TGTDIR" ]; then
			mkdir -p "$TGTDIR"
		fi
		cp $1/D12/bluetooth/etc/bluetooth/pan/dev_up.template /etc/bluetooth/pan
		cp $1/D12/bluetooth/etc/bluetooth/pan/dev_up.default /etc/bluetooth/pan
		cp $1/D12/bluetooth/etc/bluetooth/pan/dev_up /etc/bluetooth/pan
		cp $1/D12/bluetooth/etc/bluetooth/pan/dev_down /etc/bluetooth/pan
		cp $1/D12/bluetooth/etc/bluetooth/pan/dev_up.android_client /etc/bluetooth/pan
		chmod 777 /etc/bluetooth/pan/dev_up.template
		chmod 777 /etc/bluetooth/pan/dev_up.default
		chmod 777 /etc/bluetooth/pan/dev_up
		chmod 777 /etc/bluetooth/pan/dev_down
		chmod 777 /etc/bluetooth/pan/dev_up.android_client
		
		echo '    Installing monospace font for OLED'
		cp $1/D12/droid-sans-mono.ttf /usr/lib/fonts
		
		echo 'SMS alerts to +467190006119268'
		echo '+467190006119268' > /root/USR/sms.alert
		rm $1/TOOLS/UpdateME910firmware
	;;
	'D22')
		echo 'Doing platform-specific install tasks for D22'
		echo '    Startup scripts'
		cp $1/D22/S99startup /etc/init.d
		chmod 777 /etc/init.d/S99startup
		echo '    Creating ValvApp library symlink'
		ln -s $1/TPL-D22 /root/CFG
		
#
# Following is only really necessary if upgrading from pre-2.8.6, but we don't
# know where we"re coming from so do it anyway
#
		TGTDIR="/root/MODBUS"
		if [ -d "$TGTDIR" ]; then
			echo '    Cleaning up superfluous Modbus object definition files'
			TMPDIR="/tmp/MODBUS"
			mkdir -p $TMPDIR
#
# Set up input file name: list of used modbus objects
#
			_input="/root/REMOTE_OBJECTS/modbusobjects.def"
#
# Read through source file, line by line.
#
			if [ -f $_input ]; then
				while IFS= read -r str
					do
					if [ ${str:0:10} == "Equipment=" ]; then
#
# Line defines an equipment: extract the definition file name (which is, it
# would seem, actually used).
#
						fname=${str:10:100}
#
# This gets us the comma-separated parameter list ...
#
						fname=$(echo $fname | cut -d , -f 1)
#
# ... and this gets us the first element (the definition file name.
#
						echo "        Found used MODBUS definition file: "$fname
						cp $TGTDIR/$fname $TMPDIR
#
# Copy used definition file to temp directory
#
					fi
					done <"$_input"
				rm $TGTDIR/*.def
#
# Remove ALL definition files ...
#
				mv $TMPDIR/*.def $TGTDIR
#
# ... then shift saved (used) ones back in there
#
			else
#
# No modbus objects defined, so zap all Modbus definition files
#
				rm $TGTDIR/*.def
			fi
			rmdir $TMPDIR
		fi
		
		echo '    Installing Modbus device definitions'
		if [ ! -d "$TGTDIR" ]; then
			mkdir -p "$TGTDIR"
		fi
#
# Remove obsolete definition files from versions previous to 2.6.0
#
		FNAME=$TGTDIR/MetriNetChl*
		test -f $FNAME && (rm $FNAME)
#
# Copy new Modbus device definitions
#
		cp $1/D22/MODBUS/* "$TGTDIR"
#
# Delete inappropriate modem f/w update tool from package/TOOLS directory
#
		if [ $HWREV == 'A' ]; then
			rm $1/TOOLS/UpdateME910firmware
		else
			rm $1/TOOLS/UpdateModemFirmware
			mv $1/TOOLS/UpdateME910firmware $1/TOOLS/UpdateModemFirmware
		fi
	;;
	*)
		echo 'Unknown platform: assuming D22'
		echo '    Startup scripts'
		cp $1/D22/S99startup /etc/init.d
		chmod 777 /etc/init.d/S99startup
		echo '    Creating ValvApp library symlink'
		ln -s $1/TPL-D22 /root/CFG
		echo '    Installing Modbus device definitions'
		TGTDIR="/root/MODBUS"
		if [ ! -d "$TGTDIR" ]; then
			mkdir -p "$TGTDIR"
		fi
		cp $1/D22/MODBUS/* "$TGTDIR"
esac
echo 'Doing common install tasks ...'
echo '    Debug traces enabled'
echo 'on' > /root/USR/debug.enabled
#
# Remove obsolete DPM data directory (if present), install standard tables.
# Do NOT delete any, might be specific/custom tables present.
#
if [ -d "/root/DPM/DTA" ]; then
	rm -rf /root/DPM/DTA
fi
if [ -d "/root/DPM/CSV" ]; then
	rm -rf /root/DPM/CSV
fi
if [ $PLATFORM != 'D11' ]; then
	echo '    installing standard DP metering tables'
	mkdir -p /root/DPM
	cp $1/DPM/*.csv /root/DPM
fi
#
# Just in case we've been updated with a remote update still underway, delete
# the remote update journal file (so as not to retry).
#
FNAME="/root/USR/packagedownload.journal"
test -f $FNAME && (rm $FNAME)
#
# Make bloody sure that the jdiff/jptch tools are present
# NOTE THESE ARE NOW IN rootfs
#
echo '    installing jdiff/jptch tools'
test -f /usr/sbin/jdiff || (cp -f $1/jdiff /usr/sbin && chmod 777 /usr/sbin/jdiff)
test -f /usr/sbin/jptch || (cp -f $1/jptch /usr/sbin && chmod 777 /usr/sbin/jptch)
#
# Ensure all required directories are present
#
echo '    creating required directories'
TGTDIR="/root/LOG"
if [ ! -d "$TGTDIR" ]; then
	mkdir -p "$TGTDIR"
fi
TGTDIR="/root/RDX"
if [ ! -d "$TGTDIR" ]; then
	mkdir -p "$TGTDIR"
fi
TGTDIR="/root/USR"
if [ ! -d "$TGTDIR" ]; then
	mkdir -p "$TGTDIR"
	TGTDIR=$TGTDIR"/BAK"
	mkdir -p "$TGTDIR"
fi
TGTDIR="/root/REMOTE_OBJECTS"
if [ ! -d "$TGTDIR" ]; then
    echo '       moving existing remote object definitions to '$TGTDIR
	mkdir -p "$TGTDIR"
    mv /root/RDX/modbusobjects.def $TGTDIR
    mv /root/RDX/remote.mapping $TGTDIR
    mv /root/RDX/*.params $TGTDIR
    mv /root/RDX/*.subscribe $TGTDIR
fi
#
# Ensure stackdump library is present: create required symlinks
# NOTE THESE ARE NOW IN rootfs (D22)
#
echo '    stack dump support (debugging)'
test -f /lib/libubacktrace-0.9.33.so || (cp $1/updatelib/libubacktrace-0.9.33.so /lib && chmod 777 /lib/libubacktrace-0.9.33.so)
test -h /lib/libubacktrace.so.0 || ln -s /lib/libubacktrace-0.9.33.so /lib/libubacktrace.so.0
#
# Ensure iptables and supporting libraries are present: create required symlinks
# NOTE THESE ARE NOW IN rootfs
#
echo '    iptables support'
test -f /usr/sbin/xtables-multi || cp $1/updateipt/xtables-multi /usr/sbin
chmod 777 /usr/sbin/xtables-multi
test -h /usr/sbin/iptables || ln -s /usr/sbin/xtables-multi /usr/sbin/iptables
test -h /usr/sbin/iptables-restore || ln -s /usr/sbin/xtables-multi /usr/sbin/iptables-restore
test -h /usr/sbin/iptables-save || ln -s /usr/sbin/xtables-multi /usr/sbin/iptables-save

test -f /usr/lib/libip4tc.so.0.0.0 || (cp $1/updateipt/libip4tc.so.0.0.0 /usr/lib && chmod 777 /usr/lib/libip4tc.so.0.0.0)
test -h /usr/lib/libip4tc.so || ln -s /usr/lib/libip4tc.so.0.0.0 /usr/lib/libip4tc.so
test -h /usr/lib/libip4tc.so.0 || ln -s /usr/lib/libip4tc.so.0.0.0 /usr/lib/libip4tc.so.0
test -f /usr/lib/libip6tc.so.0.0.0 || (cp $1/updateipt/libip6tc.so.0.0.0 /usr/lib && chmod 777 /usr/lib/libip6tc.so.0.0.0)
test -h /usr/lib/libip6tc.so || ln -s /usr/lib/libip6tc.so.0.0.0 /usr/lib/libip6tc.so
test -h /usr/lib/libip6tc.so.0 || ln -s /usr/lib/libip6tc.so.0.0.0 /usr/lib/libip6tc.so.0
test -f /usr/lib/libiptc.so.0.0.0 || (cp $1/updateipt/libiptc.so.0.0.0 /usr/lib && chmod 777 /usr/lib/libiptc.so.0.0.0)
test -h /usr/lib/libiptc.so || ln -s /usr/lib/libiptc.so.0.0.0 /usr/lib/libiptc.so
test -h /usr/lib/libiptc.so.0 || ln -s /usr/lib/libiptc.so.0.0.0 /usr/lib/libiptc.so.0
test -f /usr/lib/libxtables.so.7.0.0 || (cp $1/updateipt/libxtables.so.7.0.0 /usr/lib && chmod 777 /usr/lib/libxtables.so.7.0.0)
test -h /usr/lib/libxtables.so || ln -s /usr/lib/libxtables.so.7.0.0 /usr/lib/libxtables.so
test -h /usr/lib/libxtables.so.0 || ln -s /usr/lib/libxtables.so.7.0.0 /usr/lib/libxtables.so.0
test -h /usr/lib/libxtables.so.7 || ln -s /usr/lib/libxtables.so.7.0.0 /usr/lib/libxtables.so.7
#
# install VNC libraries
# NOTE THESE ARE NOW IN rootfs
#
echo '    VNC support'
cp -f $1/updatevnc/libvncclient.so.0.0.0 /usr/lib
test -h /usr/lib/libvncclient.so || ln -s /usr/lib/libvncclient.so.0.0.0 /usr/lib/libvncclient.so
test -h /usr/lib/libvncclient.so.0 || ln -s /usr/lib/libvncclient.so.0.0.0 /usr/lib/libvncclient.so.0
cp -f $1/updatevnc/libvncserver.so.0.0.0 /usr/lib
test -h /usr/lib/libvncserver.so || ln -s /usr/lib/libvncserver.so.0.0.0 /usr/lib/libvncserver.so
test -h /usr/lib/libvncserver.so.0 || ln -s /usr/lib/libvncserver.so.0.0.0 /usr/lib/libvncserver.so.0
TGTDIR="/usr/lib/qt/plugins/gfxdrivers"
if [ ! -d "$TGTDIR" ]; then
	mkdir -p "$TGTDIR"
fi
cp -f $1/updatevnc/libvncserverscreen.so $TGTDIR
#
# Install VNC config files
# NOTE THESE ARE NOW IN rootfs
#
TGTDIR="/etc/vnc"
if [ ! -d "$TGTDIR" ]; then
	mkdir -p "$TGTDIR"
fi
cp -f $1/updatevnc/vnc.access /etc/vnc
cp -f $1/updatevnc/profile /etc
#
# install required support files for QWS keyboard/mouse injection
#
# THESE ARE NOT YET IN ROOTFS!
#
echo '    Keyboard/mouse record/playback support'
cp -f $1/updateqws/etc/profile /etc
#
# This is to set QWS variables in the interactive session.
# NOTE that this will overwrite the copy we've just done for VNC!
#
# TO BE CLEANED UP!
#
#
# Copy mouse and keyboard drivers into Qt plugin directories
#
TGTDIR="/usr/lib/qt/plugins/kbddrivers"
if [ ! -d "$TGTDIR" ]; then
	mkdir -p "$TGTDIR"
fi
cp -f $1'/updateqws'$TGTDIR'/libRemoteKbdHandler.so' $TGTDIR
TGTDIR="/usr/lib/qt/plugins/mousedrivers"
if [ ! -d "$TGTDIR" ]; then
	mkdir -p "$TGTDIR"
fi
cp -f $1'/updateqws'$TGTDIR'/libRemoteMouHandler.so' $TGTDIR
#
# Use a symlink in /root/BIN to point to the RemoteControl tool: zap
# it first if it already exists
#
rm /root/BIN/RemoteControl
ln -s $1'/TOOLS/CLI/RemoteControl' /root/BIN/RemoteControl
# install new firewall scripts
# NOTE THESE ARE NOW IN rootfs
#
echo '    firewall scripts'
cp -f $1/firewall/firewall-on /etc/network
chmod 777 /etc/network/firewall-on
cp -f $1/firewall/firewall-off /etc/network
chmod 777 /etc/network/firewall-off
cp -f $1/firewall/firewall.rules /etc/network
#
# ensure ppp config files present
# NOTE THESE ARE NOW IN rootfs
#
echo '    pppd support'
TGTDIR="/etc/ppp/peers"
if [ ! -d "$TGTDIR" ]; then
	mkdir -p "$TGTDIR"
fi
TGTDIR="/etc/chatscripts"
if [ ! -d "$TGTDIR" ]; then
	mkdir -p "$TGTDIR"
fi
cp -f $1/updateppp/chatscripts/u-blox.template /etc/chatscripts
cp -f $1/updateppp/ppp/peers/u-blox.template /etc/ppp/peers
cp -f $1/updateppp/ppp/ip-up /etc/ppp/ip-up
chmod 777 /etc/ppp/ip-up
cp -f $1/updateppp/ppp/ip-down /etc/ppp/ip-down
chmod 777 /etc/ppp/ip-down
cp -f $1/updateppp/ppp/ppp-down /etc/ppp/ppp-down
chmod 777 /etc/ppp/ppp-down
#
# Install local DNS caching/proxy server
#
# First of all, kill dnsmasq if it's running
# NOTE THESE ARE NOW IN rootfs
echo '    dnsmasq support'
killall dnsmasq
cp -f $1/updatedns/dnsmasq /usr/sbin/dnsmasq
chmod 777 /usr/sbin/dnsmasq
cp -f $1/updatedns/init.d/S90dnsmasq /etc/init.d
chmod 777 /etc/init.d/S90dnsmasq
cp -f $1/updatedns/etc/dnsmasq.conf /etc
cp -f $1/updatedns/etc/hosts.template /etc
cp -f $1/updatedns/etc/hosts.extra /etc
#
# Set up default name resolution files (all local DNS requests go to localhost (ie dnsmasq)
# and dnsmasq will use 8.8.8.8 as the upstream server.
#
echo "nameserver 127.0.0.1" > /etc/resolv.conf
echo "nameserver 8.8.8.8" > /etc/resolv.dnsmasq
#
# As of 2.4.0, dhcp is installed for ALL Dxx devices
#
echo '    dhcp server'
test -f /usr/sbin/dhcpd || cp $1/updatedhcp/usr/sbin/dhcpd /usr/sbin
chmod 777 /usr/sbin/dhcpd
TGTDIR="/etc/dhcp"
if [ ! -d "$TGTDIR" ]; then
    mkdir -p "$TGTDIR"
fi
cp $1/updatedhcp/etc/dhcp/dhcpd.template $TGTDIR
cp $1/updatedhcp/etc/dhcp/dhcpd.default $TGTDIR
cp $1/updatedhcp/etc/dhcp/dhcpd.conf $TGTDIR
cp $1/updatedhcp/etc/dhcp/dh-androidclient-script $TGTDIR
chmod 777 $TGTDIR/dh-androidclient-script
cp $1/updatedhcp/etc/init.d/S80dhcp-server /etc/init.d && chmod 777 /etc/init.d/S80dhcp-server
#
# Add Wifi support for everyone
#
echo '    WiFi AP support'
cp $1/updatewifi/etc/init.d/S60wifi /etc/init.d
chmod 777 /etc/init.d/S60wifi
# RTL8188 chipset driver is a loadable module, so stick it where it should be. Also,
# differs between kernels (USB? data structures changed) so copy appropriate version
TGTDIR="/lib/modules/2.6.35.3/kernel/drivers/net/wireless/"
if [ ! -d "$TGTDIR" ]; then
    mkdir -p "$TGTDIR"
fi
if [ $PLATFORM = 'D22' ]; then
    cp $1/updatewifi/lib/8188eu.ko.D22 $TGTDIR/8188eu.ko
else
    cp $1/updatewifi/lib/8188eu.ko.D1x $TGTDIR/8188eu.ko
fi
# This driver doesn't have the firmware built-in, so that needs to be put in the right place
TGTDIR="/lib/firmware/rtlwifi"
if [ ! -d "$TGTDIR" ]; then
    mkdir -p "$TGTDIR"
fi
cp $1/updatewifi/lib/rtl8188eufw.bin $TGTDIR
TGTDIR="/etc/hostapd"
if [ ! -d "$TGTDIR" ]; then
    mkdir -p "$TGTDIR"
fi
cp $1/updatewifi$TGTDIR/hostapd.template $TGTDIR
# Tidy up possible leftovers from an old rootfs
test -f /usr/bin/hostapd && rm /usr/bin/hostapd
test -f /usr/bin/hostapd_cli && rm /usr/bin/hostapd_cli
# Replace with correct files
cp $1/updatewifi/hostapd /usr/sbin && chmod 777 /usr/sbin/hostapd
cp $1/updatewifi/hostapd_cli /usr/sbin && chmod 777 /usr/sbin/hostapd_cli
#
# Copy over and make shortcuts for new libraries: gnutls and readline
# NOTE THESE ARE NOW IN rootfs
#
echo '    extra libraries'
test -f /usr/lib/libgnutls-extra.so.26.16.14 || (cp $1/updatelib/libgnutls-extra.so.26.16.14 /usr/lib && chmod 777 /usr/lib/libgnutls-extra.so.26.16.14)
test -h /usr/lib/libgnutls-extra.so || ln -s /usr/lib/libgnutls-extra.so.26.16.14 /usr/lib/libgnutls-extra.so
test -h /usr/lib/libgnutls-extra.so.26 || ln -s /usr/lib/libgnutls-extra.so.26.16.14 /usr/lib/libgnutls-extra.so.26

test -f /usr/lib/libgnutls-openssl.so.26.16.14 || (cp $1/updatelib/libgnutls-openssl.so.26.16.14 /usr/lib && chmod 777 /usr/lib/libgnutls-openssl.so.26.16.14)
test -h /usr/lib/libgnutls-openssl.so || ln -s /usr/lib/libgnutls-openssl.so.26.16.14 /usr/lib/libgnutls-openssl.so
test -h /usr/lib/libgnutls-openssl.so.26 || ln -s /usr/lib/libgnutls-openssl.so.26.16.14 /usr/lib/libgnutls-openssl.so.26

test -f /usr/lib/libgnutls.so.26.16.14 || (cp $1/updatelib/libgnutls.so.26.16.14 /usr/lib && chmod 777 /usr/lib/libgnutls.so.26.16.14)
test -h /usr/lib/libgnutls.so || ln -s /usr/lib/libgnutls.so.26.16.14 /usr/lib/libgnutls.so
test -h /usr/lib/libgnutls.so.26 || ln -s /usr/lib/libgnutls.so.26.16.14 /usr/lib/libgnutls.so.26

test -f /usr/lib/libgnutlsxx.so.26.16.14 || (cp $1/updatelib/libgnutlsxx.so.26.16.14 /usr/lib && chmod 777 /usr/lib/libgnutlsxx.so.26.16.14)
test -h /usr/lib/libgnutlsxx.so || ln -s /usr/lib/libgnutlsxx.so.26.16.14 /usr/lib/libgnutlsxx.so
test -h /usr/lib/libgnutlsxx.so.26 || ln -s /usr/lib/libgnutlsxx.so.26.16.14 /usr/lib/libgnutlsxx.so.26

test -f /usr/lib/libreadline.so.6.2 || (cp $1/updatelib/libreadline.so.6.2 /usr/lib && chmod 777 /usr/lib/libreadline.so.6.2)
test -h /usr/lib/libreadline.so || ln -s /usr/lib/libreadline.so.6.2 /usr/lib/libreadline.so
test -h /usr/lib/libreadline.so.6 || ln -s /usr/lib/libreadline.so.6.2 /usr/lib/libreadline.so.6

test -f /usr/lib/libexpat.so.1.5.2 || (cp $1/updatelib/libexpat.so.1.5.2 /usr/lib && chmod 777 /usr/lib/libexpat.so.1.5.2)
test -h /usr/lib/libexpat.so || ln -s /usr/lib/libexpat.so.1.5.2 /usr/lib/libexpat.so
test -h /usr/lib/libexpat.so.1 || ln -s /usr/lib/libexpat.so.1.5.2 /usr/lib/libexpat.so.1

#
# If we're updating from 1.9.0 the json libraries will NOT be updated, because
# they're included in that package: sadly it's the 32-bit version rather than 
# the 64-bit, which'll screw things up royally. So even if libjson exists we
# copy the sucker anyway.
#
#test -f /usr/lib/libjson.so.0.0.1 || (cp $1/updatelib/libjson.so.0.0.1 /usr/lib && chmod 777 /usr/lib/libjson.so.0.0.1)
cp -f $1/updatelib/libjson.so.0.0.1 /usr/lib
chmod 777 /usr/lib/libjson.so.0.0.1
#
# But if the symlinks exist we don't need to touch them.
#
test -h /usr/lib/libjson.so || ln -s /usr/lib/libjson.so.0.0.1 /usr/lib/libjson.so
test -h /usr/lib/libjson.so.0 || ln -s /usr/lib/libjson.so.0.0.1 /usr/lib/libjson.so.0
#
# Copy over lftp package and conf file
# NOTE THESE ARE NOW IN rootfs
#
echo '    lftp package'
cp $1/updatelftp/lftp /usr/sbin
chmod 777 /usr/sbin/lftp
cp $1/updatelftp/lftp.conf /etc
cp $1/updatelftp/lftp.sync /etc
#
# Add curl package
# NOTE THIS IS NOW IN rootfs
#
echo '    curl package (TLS 1.2)'
#
# If already exists, curl may be an old version (TLS 1.0 only) so always update
#
test -f /usr/sbin/curl && rm /usr/sbin/curl
#
# Don't want a redundant copy in sbin, so zap if it exists
#
cp $1/updatetls_1.2/curl /usr/bin && chmod 777 /usr/bin/curl
cp -f $1/updatetls_1.2/libcurl.so.4.3.0 /usr/lib
#
# Replace existing symlinks for libcurl
#
test -h /usr/lib/libcurl.so && rm /usr/lib/libcurl.so
ln -s /usr/lib/libcurl.so.4.3.0 /usr/lib/libcurl.so
test -h /usr/lib/libcurl.so.4 && rm /usr/lib/libcurl.so.4
ln -s /usr/lib/libcurl.so.4.3.0 /usr/lib/libcurl.so.4
#
cp -f $1/updatetls_1.2/libssh2.so.1.0.1 /usr/lib
test -h /usr/lib/libssh2.so.1 || ln -s /usr/lib/libssh2.so.1.0.1 /usr/lib/libssh2.so.1
#
echo '    openssl (TLS 1.2)'
#
cp -f $1/updatetls_1.2/openssl /usr/bin && chmod 777 /usr/bin/openssl
#
# NOTE we don't need to change the symlinks for the following: file versions
# haven't changed so symlinks from rootfs still OK.
#
cp -f $1/updatetls_1.2/libcrypto.so.1.0.0 /usr/lib
cp -f $1/updatetls_1.2/libssl.so.1.0.0 /usr/lib
#
# As of 2.8.6, don't use SSL certificates. If they exist on the target (from
# a previous installation) delete them AND the /root/SSL directory. But we
# DO create (if necessary) /root/JWT to hold the string used by the new JWT
# based token ID system.
#
TGTDIR="/root/SSL"
if [ -d $TGTDIR ]; then
	echo '    Removing old SSL certificate bundle'
    rm $TGTDIR/* && rmdir $TGTDIR
fi
TGTDIR="/root/JWT"
if [ ! -d $TGTDIR ]; then
	echo '    Creating directory for JWT tokens'
    mkdir -p $TGTDIR
fi
#
# As of 2.8.7, we'll be using SSL for MQTT transfers. To avoid conflicts with earlier
# versions, call the storage directory /root/certs
#
TGTDIR="/root/certs"
if [ ! -d $TGTDIR ]; then
	echo '    Creating SSL certificate directory'
    mkdir $TGTDIR
fi
#
# As of 2.9.1, use a CA bundle to authenticate the L2V server. Always install the prod version.
#
#echo '    L2V certificate bundle'
#
SRCDIR="$1/updatetls_1.2"
CPYFILE="CABundle.crt"
cp $SRCDIR/$CPYFILE $TGTDIR
#
echo '    openssh (for sftp, scp ...)'
#
# Remove existing copy of ssh if exists and is a symlink (to dropbear): idem scp
#
test -h /usr/bin/ssh && rm /usr/bin/ssh
test -h /usr/bin/scp && rm /usr/bin/scp
#
# Copy over ssh execs: ssh, scp, sftp etc
SRCDIR="$1/updatessh/bin"
TGTDIR="/usr/bin"
chmod 777 $SRCDIR/*
cp $SRCDIR/* $TGTDIR
#
# Copy over the known hosts file
#
echo '        ssh support files'
SRCDIR="$1/updatessh/support"
TGTDIR="/root/.ssh"
mkdir -p $TGTDIR
cp $SRCDIR"/known_hosts" $TGTDIR
#
# Copy other support files and we're done
#
echo "prod" > $TGTDIR"/ftppass"
#
echo '    lighttpd package'
#
# Ensure HTTP server root exists
if [ ! -d "/var/www" ]; then
    mkdir -p "/var/www"
fi
# Make a link to R-Ui icons for use by the HTML pages
test -h /var/www/icons && rm /var/www/icons
ln -s $1/icons /var/www/icons
# Make a link for R-Ui translation data
test -h /var/www/lang && rm /var/www/lang
ln -s $1/LANG /var/www/lang
# If required, add a link to /root so web server can footle around in there
test -h /var/www/file_system || ln -s /root /var/www/file_system
test -h /var/www/tmp || ln -s /tmp /var/www/tmp
# Copy over web pages
cp -r $1/updatelighttpd/www/* /var/www
# Install conf files, binaries, libs
#
cp $1/updatelighttpd/etc/init.d/S50lighttpd /etc/init.d && chmod 777 /etc/init.d/S50lighttpd
cp -r $1/updatelighttpd/etc/lighttpd/ /etc
cp -r $1/updatelighttpd/usr/lib/lighttpd/ /usr/lib
cp $1/updatelighttpd/usr/sbin/* /usr/sbin
#
echo '    php package'
#
cp $1/updatephp/etc/php.ini /etc
cp -r $1/updatephp/usr/lib/php/ /usr/lib
cp $1/updatephp/usr/bin/* /usr/bin
#
# Install libraries for MQTT protocol (optional for logging, peering ...
#
echo '    MQTT support'
SRCDIR="$1/updatemqtt"
TGTDIR="/usr/lib"
test -f $TGTDIR/libpaho-mqtt3a.so.1.3 || (cp $SRCDIR/libpaho-mqtt3a.so.1.3 $TGTDIR && chmod 777 $TGTDIR/libpaho-mqtt3a.so.1.3)
test -h $TGTDIR/libpaho-mqtt3a.so || ln -s $TGTDIR/libpaho-mqtt3a.so.1.3 $TGTDIR/libpaho-mqtt3a.so
test -h $TGTDIR/libpaho-mqtt3a.so.1 || ln -s $TGTDIR/libpaho-mqtt3a.so.1.3 $TGTDIR/libpaho-mqtt3a.so.1
test -f $TGTDIR/libpaho-mqtt3as.so.1.3 || (cp $SRCDIR/libpaho-mqtt3as.so.1.3 $TGTDIR && chmod 777 $TGTDIR/libpaho-mqtt3as.so.1.3)
test -h $TGTDIR/libpaho-mqtt3sa.so || ln -s $TGTDIR/libpaho-mqtt3as.so.1.3 $TGTDIR/libpaho-mqtt3as.so
test -h $TGTDIR/libpaho-mqtt3sa.so.1 || ln -s $TGTDIR/libpaho-mqtt3as.so.1.3 $TGTDIR/libpaho-mqtt3as.so.1
test -f $TGTDIR/libpaho-mqtt3c.so.1.3 || (cp $SRCDIR/libpaho-mqtt3c.so.1.3 $TGTDIR && chmod 777 $TGTDIR/libpaho-mqtt3c.so.1.3)
test -h $TGTDIR/libpaho-mqtt3c.so || ln -s $TGTDIR/libpaho-mqtt3c.so.1.3 $TGTDIR/libpaho-mqtt3c.so
test -h $TGTDIR/libpaho-mqtt3c.so.1 || ln -s $TGTDIR/libpaho-mqtt3c.so.1.3 $TGTDIR/libpaho-mqtt3c.so.1
test -f $TGTDIR/libpaho-mqtt3cs.so.1.3 || (cp $SRCDIR/libpaho-mqtt3cs.so.1.3 $TGTDIR && chmod 777 $TGTDIR/libpaho-mqtt3cs.so.1.3)
test -h $TGTDIR/libpaho-mqtt3cs.so || ln -s $TGTDIR/libpaho-mqtt3cs.so.1.3 $TGTDIR/libpaho-mqtt3cs.so
test -h $TGTDIR/libpaho-mqtt3cs.so.1 || ln -s $TGTDIR/libpaho-mqtt3cs.so.1.3 $TGTDIR/libpaho-mqtt3cs.so.1
#
# Add odds'n'sods. For 1.7.2.C, install miniunz tool
#
echo '    extras'
# NOTE THIS IS NOW IN rootfs
test -f /root/BIN/miniunz || (cp $1/miniunz /root/BIN && chmod 777 /root/BIN/miniunz)
test -f /usr/bin/netcat || (cp $1/netcat /usr/bin && chmod 777 /usr/bin/netcat)
cp $1/TIMEZONES.csv /root
cp $1/COUNTRYLIST.csv /root
#
# Cleanup
#
#echo '    cleaning up install directories'
#rm -r $1/firewall
#rm -r $1/updateipt
#rm -r $1/updatevnc
#rm -r $1/updatedns
#rm -r $1/updatelib
#rm -r $1/updateppp
#rm -r $1/updatelftp
#rm -r $1/updatetls_1.2
#
# Force save to filesystem
#
sync
#
# Update PIC f/w and the kernel to the latest version if required
#
#case $PLATFORM in
#	'D11')
#		$1/TOOLS/CLI/PICprogrammer || $1/HelpScreen -qws -display "multi: LinuxFb: VNC::size=640x272"
#		$1/TOOLS/CLI/InstallKernel $1/updateknl 'D12-kernel 220807.ker'
#	;;
#	'D12')
#		$1/TOOLS/CLI/PICprogrammer || $1/HelpScreen -qws -display "multi: LinuxFb: VNC::size=640x272"
#		$1/TOOLS/CLI/InstallKernel $1/updateknl 'D12-kernel 220807.ker'
#	;;
#	'D22')
#		$1/TOOLS/CLI/PICprogrammer || $1/HelpScreen -qws -display "multi: LinuxFb: VNC::size=640x272"
#		$1/TOOLS/CLI/InstallKernel $1/updateknl 'D22-kernel 220807.ker'
#	;;
#	*)
#		$1/TOOLS/CLI/PICprogrammer || $1/HelpScreen -qws -display "multi: LinuxFb: VNC::size=640x272"
#		$1/TOOLS/CLI/InstallKernel $1/updateknl 'D22-kernel 220807.ker'
#esac
#
# Delete ourself so that IF the following fails we don't get re-run next time
# the system starts (eternal reboot loop). ID #266, V2.8.2
#
echo "Deleting package file "$PACKAGE
rm $1/runonce.sh
rm $PACKAGE
sync
#
# Create synchronisation directories on SD card. This done LAST 'cos if the SD
# card is fscked it may cause a reboot. ID #266, V2.8.2
#
TGTDIR="/media/mmc/SYNC/UP"
if [ ! -d "$TGTDIR" ]; then
	mkdir -p "$TGTDIR"
fi
TGTDIR="/media/mmc/SYNC/DOWN"
if [ ! -d "$TGTDIR" ]; then
	mkdir -p "$TGTDIR"
fi
#
# If logfile backup directory on SD card (pre-2.5.2) doesn't exist, rename existing
# /media/mmc/LOG as /media/mmc/LOG.BAK and create a new one. With 2.5.2 the directory
# structure changed ...
#
if [ ! -d "/media/mmc/LOG.BAK" ]; then
	mv "/media/mmc/LOG" "/media/mmc/LOG.BAK"
	mkdir -p "/media/mmc/LOG"
fi
#
# Idem for ValvApp backups (from 2.6.0 on)
#
if [ ! -d "/media/mmc/BAK.BAK" ]; then
	mv "/media/mmc/BAK" "/media/mmc/BAK.BAK"
	mkdir -p "/media/mmc/BAK"
fi
echo 'Done!'
#
# Restart watchdog and quit
#
/root/BIN/R-Watchdog &
