<!DOCTYPE html>
<?php
$page_name = "Advanced";
?>
<html>
<head>
    <?php include("shared/head.php");?>

    <!-- Page title -->
    <title>Web Engine - <?php echo $page_name?></title>
</head>
<body>

<!-- Simple splash screen-->
<div class="splash"> <div class="color-line"></div></div>
<!--[if lt IE 7]>
<p class="alert alert-danger">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
<![endif]-->

<!-- Header -->
<div id="header">
    <?php include("shared/header.php");?>
</div>

<!-- Navigation -->
<aside id="menu">
    <?php include("shared/menu.php");?>
</aside>

<!-- Main Wrapper -->
<div id="wrapper" ng-app="WebEngine">
    <div class="content animate-panel">
        <div class="row">
          <div class="col-lg-4">
              <div class="hpanel">
                  <div class="panel-heading">
                      <div class="panel-tools">
                          <a class="showhide"><i class="fa fa-chevron-up"></i></a>
                      </div>
                      Engine Update
                  </div>
                  <div class="panel-body">
                      <div class="form-horizontal" ng-controller="updateEngine">
                        <input type="file" class="custom-file-input" select-ng-files ng-model="file" accept=".tar"></br>
                        <button id="update_engine_btn" type="button" class="btn btn-block btn-outline btn-default" ng-click="click()" ng-disabled="loading">
                            <div ng-hide="loading">
                                <img src="icons/EngineUpdate.png" alt="Update Engine" height="30" width="30"></br>Update Engine
                            </div>
                            <div ng-show="loading">
                                <span><i class="glyphicon glyphicon-refresh spinning"></i></span></br>Loading ...
                            </div>
                        </button>
                      </div>
                  </div>
              </div>
          </div>

          <div class="col-lg-4">
              <div class="hpanel">
                  <div class="panel-heading">
                      <div class="panel-tools">
                          <a class="showhide"><i class="fa fa-chevron-up"></i></a>
                      </div>
                      Diag->USB
                  </div>
                  <div class="panel-body">
                      <div class="form-horizontal">
                        <button id="export_diag_btn" type="button" class="btn btn-block btn-outline btn-default" ng-controller="getFileButton" ng-init="init('advanced_diag')" ng-click="click()" ng-disabled="loading">
                            <div ng-hide="loading">
                                <img src="icons/Diag2Usb.png" alt="Export Diag" height="30" width="30"></br>Export Diag
                            </div>
                            <div ng-show="loading">
                                <span><i class="glyphicon glyphicon-refresh spinning"></i></span></br>Loading ...
                            </div>
                        </button>
                      </div>
                  </div>
              </div>
          </div>

          <div class="col-lg-4">
              <div class="hpanel">
                  <div class="panel-heading">
                      <div class="panel-tools">
                          <a class="showhide"><i class="fa fa-chevron-up"></i></a>
                      </div>
                      Reboot
                  </div>
                  <div class="panel-body">
                      <div class="form-horizontal">
                        <button id="reboot_btn" type="button" class="btn btn-block btn-outline btn-default" ng-controller="rebootButton" ng-click="click()"><img src="icons/Restart.png" alt="Reboot" height="30" width="30"></br>Reboot</button>
                      </div>
                  </div>
              </div>
          </div>

        </div>
    </div>

    <?php include("shared/footer.php");?>

</div>

<?php include("shared/scripts.php");?>

</body>
</html>
