<?php
ob_start();
require_once('rengine-API.php');

$method = $_SERVER['REQUEST_METHOD'];
//Receive the RAW post data.
$content = trim(file_get_contents("php://input"));
//Attempt to decode the incoming RAW post data from JSON.
$decoded = json_decode($content, JSON_PRETTY_PRINT);

$myfile = fopen("tmp/debug.txt", "w");
fwrite($myfile, "\nDATE & TIME :\t".date("Y-m-d H:i:s e")."\n" );
fwrite($myfile, "METHOD :\t".$method."\n" );
fwrite($myfile, "RAW :\t\t".$content."\n" );

if (isset($decoded['action'])) {
    switch ($decoded['action']) {

        case 'get_value':
            header('Content-Type: text/json');
            $return["value"] = get_value($decoded['param']);
            echo json_encode($return);
            fwrite($myfile, "RESPONSE :\t".json_encode($return)."\n\n" );
            break;

        case 'set_value':
            header('Content-Type: text/json');
            $return["result"] = set_value($decoded['param'],$decoded['value']);
            $return["value"] = get_value($decoded['param']);
            echo json_encode($return);
            fwrite($myfile, "RESPONSE :\t".json_encode($return)."\n\n" );
            break;

        case 'information_export':
            $filepath = export_info();
            fwrite($myfile,"FILEPATH :\t" . $filepath . "\n" );
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename="'.basename($filepath).'"');
            header('Content-Length: ' . filesize($filepath));
            flush(); // Flush system output buffer
            readfile($filepath);
            //unlink($filepath);
            break;

        case 'logging_export':
            header('Content-Type: text/json');
            $return["result"] = logging_export($decoded['value']);
            echo json_encode($return);
            fwrite($myfile, "RESPONSE :\t".json_encode($return)."\n\n" );
            break;

        case 'logging_export_status':
            $status = logging_exportstatus();
            fwrite($myfile,"STATUS :\t" . $status . "\n" );
            header('Content-Type: text/json');
            $return["status"] = $status;
            echo json_encode($return);
            fwrite($myfile, "RESPONSE :\t".json_encode($return)."\n\n" );
            break;

        case 'logging_export_download':
            if(ini_get('zlib.output_compression')){
                ini_set('zlib.output_compression', 'Off');
            }
            $filepath = "tmp/" . $decoded['value'];
            fwrite($myfile,"FILEPATH :\t" . $filepath . "\nBASE NAME :\t".basename($filepath). "\nFILE SIZE :\t".filesize($filepath)."\n\n" );

            header("Pragma: public");
            header("Expires: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Cache-Control: private",false);
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename="'.basename($filepath).'"');
            header("Content-Transfer-Encoding: binary");
            header('Content-Length: ' . filesize($filepath));
            while (ob_get_level()) {
                ob_end_clean();
            }
            readfile($filepath);
            unlink($filepath);
            break;

        case 'app_mgmt_backup':
            header('Content-Type: text/json');
            $return["result"] = valvapp_backup();
            echo json_encode($return);
            fwrite($myfile, "RESPONSE :\t".json_encode($return)."\n\n" );
            break;

        case 'app_mgmt_list':
            header('Content-Type: text/json');
            $return["result"] = valvapp_list("bak");
            echo json_encode($return);
            fwrite($myfile, "RESPONSE :\t".json_encode($return)."\n\n" );
            break;

        case 'app_mgmt_restore':
            header('Content-Type: text/json');
            $result = valvapp_restore("bak",$decoded['value']);
            $return["result"] = $result;
            echo json_encode($return);
            fwrite($myfile, "RESPONSE :\t".json_encode($return)."\n\n" );
            if($result == "OK"){
                reboot();
            }
            break;

        case 'app_mgmt_export':
            $filepath = "tmp/".valvapp_export();
            fwrite($myfile,"FILEPATH :\t" . $filepath . "\nBASE NAME :\t".basename($filepath). "\nFILE SIZE :\t".filesize($filepath)."\n\n" );

            header("Pragma: public");
            header("Expires: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Cache-Control: private",false);
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename="'.basename($filepath).'"');
            header("Content-Transfer-Encoding: binary");
            header('Content-Length: ' . filesize($filepath));
            while (ob_get_level()) {
                ob_end_clean();
            }
            readfile($filepath);
            unlink($filepath);
            break;

        case 'app_mgmt_import':
            if(isset($_FILES['file'])){
                fwrite($myfile,"\nFile presents!\n" );
            }else {
                fwrite($myfile,"\nFile not presents!\n" );
            }
            fwrite($myfile,"\nFile :\n".isset($_FILES['file'])."\n" );
            fwrite($myfile,"\nFile name :\n".$decoded['name']."\n" );
            fwrite($myfile,"\nBase name : ". $decoded['file']['name']. "\nFile size : ".$decoded['file']['size']."\n\n" );
            break;

        case 'advanced_diag':
            $filepath = export_diag();
            fwrite($myfile,"FILEPATH :\t" . $filepath . "\n" );
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename="'.basename($filepath).'"');
            header('Content-Length: ' . filesize($filepath));
            flush(); // Flush system output buffer
            readfile($filepath);
            unlink($filepath);
            break;

        case 'advanced_update_status':
            $status = update_enginestatus();
            fwrite($myfile,"STATUS :\t" . $status . "\n" );
            header('Content-Type: text/json');
            $return["status"] = $status;
            echo json_encode($return);
            fwrite($myfile, "RESPONSE :\t".json_encode($return)."\n\n" );
            break;

        case 'advanced_reboot':
            reboot();
            break;

        default:
            http_response_code(404);
            break;
    }
}
else {
  http_response_code(400);
}
fclose($myfile);
?>
