<!DOCTYPE html>
<?php
$page_name = "Application Managment";
?>
<html>
<head>
    <?php include("shared/head.php");?>
    <!-- Page title -->
    <title>Web Engine - <?php echo $page_name?></title>
</head>
<body>

<!-- Simple splash screen-->
<div class="splash"> <div class="color-line"></div></div>
<!--[if lt IE 7]>
<p class="alert alert-danger">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
<![endif]-->

<!-- Header -->
<div id="header">
    <?php include("shared/header.php");?>
</div>

<!-- Navigation -->
<aside id="menu">
    <?php include("shared/menu.php");?>
</aside>

<!-- Main Wrapper -->
<div id="wrapper" ng-app="WebEngine">
    <div class="content animate-panel">
        <div class="row">
          <div class="col-lg-3">
              <div class="hpanel">
                  <div class="panel-heading">
                      <div class="panel-tools">
                          <a class="showhide"><i class="fa fa-chevron-up"></i></a>
                      </div>
                      Backup Application
                  </div>
                  <div class="panel-body">

                      <div class="form-horizontal">
                        <label>Create and save backup of the current ValvApp</label>
                        <div class="form-group">
                            <div class="col-sm-12">
                                <div class="checkbox" ng-controller="checkbox" ng-init="init('va_AutoBackup')"><label> <input type="checkbox" ng-model="checked" ng-change="change()"> Automatically back up locally every day at 23:45</label></div>
                                <div class="checkbox" ng-controller="checkbox" ng-init="init('va_AutoTransfer')"><label> <input type="checkbox" ng-model="checked" ng-change="change()"> Automatically back up to FTP server at 23:45 if the ValvApp has been changed. <br>NOTE: can generate uo to 250 KB per transfer.</label></div>
                            </div>
                        </div>
                        <button type="button" class="btn btn-block btn-outline btn-default" ng-controller="backupButton" ng-click="click()" ng-disabled="loading">
                            <div ng-hide="loading">
                                <img src="icons/Restart.png" alt="Reboot" height="30" width="30"><br>Backup Now
                            </div>
                            <div ng-show="loading">
                                <span><i class="glyphicon glyphicon-refresh spinning"></i></span><br>Loading ...
                            </div>
                        </button>
                      </div>
                  </div>
              </div>
          </div>

          <div class="col-lg-3">
              <div class="hpanel">
                  <div class="panel-heading">
                      <div class="panel-tools">
                          <a class="showhide"><i class="fa fa-chevron-up"></i></a>
                      </div>
                      Restore Application
                  </div>
                  <div class="panel-body">
                      <div class="form-horizontal" ng-controller="restoreValvApp">
                        <button type="button" class="btn btn-block btn-outline btn-default" ng-click=click() ng-disabled="disable"><img src="icons/Restore.png" alt="Restore Application" height="30" width="30"><br>Restore Application</button>
                        <br>
                        <div class="list-group" style="max-height:300px;overflow:scroll;" ng-show="showList">
                          <a href="#" class="list-group-item list-group-item-action" ng-repeat="vv_name in list" ng-click=clickVV(vv_name)>{{vv_name}}</a>
                        </div>
                        <button type="button" class="btn btn-block btn-outline btn-danger" ng-click=cancel() ng-show="showList">Cancel</button>
                      </div>
                  </div>
              </div>
          </div>

          <div class="col-lg-3">
              <div class="hpanel">
                  <div class="panel-heading">
                      <div class="panel-tools">
                          <a class="showhide"><i class="fa fa-chevron-up"></i></a>
                      </div>
                      Export Application
                  </div>
                  <div class="panel-body">
                      <div class="form-horizontal">
                        <button type="button" class="btn btn-block btn-outline btn-default" ng-controller="getFileButton" ng-init="init('app_mgmt_export')" ng-click="click()" ng-disabled="loading">
                            <div ng-hide="loading">
                                <img src="icons/ExportConfig.png" alt="Export Application" height="30" width="30"><br>Export Application
                            </div>
                            <div ng-show="loading">
                                <span><i class="glyphicon glyphicon-refresh spinning"></i></span><br>Loading ...
                            </div>
                        </button>
                      </div>
                  </div>
              </div>
          </div>

          <div class="col-lg-3">
              <div class="hpanel">
                  <div class="panel-heading">
                      <div class="panel-tools">
                          <a class="showhide"><i class="fa fa-chevron-up"></i></a>
                      </div>
                      Import Application
                  </div>
                  <div class="panel-body">
                      <div class="form-horizontal" ng-controller="importValvApp">
                        <input type="file" class="custom-file-input" select-ng-files ng-model="file" accept=".rdx"><br>
                        <button type="button" class="btn btn-block btn-outline btn-default" ng-click="click()" ng-disabled="loading">
                            <div ng-hide="loading">
                                <img src="icons/ImportConfig.png" alt="Import Application" height="30" width="30"><br>Import Application
                            </div>
                            <div ng-show="loading">
                                <span><i class="glyphicon glyphicon-refresh spinning"></i></span><br>Loading ...
                            </div>
                        </button>
                      </div>
                  </div>
              </div>
          </div>
      </div>

    <?php include("shared/footer.php");?>

    </div>

<?php include("shared/scripts.php");?>

</body>
</html>
