<!DOCTYPE html>
<?php
$page_name = "Information";
?>
<html>
<head>
    <?php include("shared/head.php");?>
    <!-- Page title -->
    <title>Web Engine - <?php echo $page_name?></title>
</head>
<body>
<!-- Header -->
<div id="header">
    <?php include("shared/header.php");?>
</div>

<!-- Navigation -->
<aside id="menu">
    <?php include("shared/menu.php");?>
</aside>

<!-- Main Wrapper -->
<div id="wrapper" ng-app="WebEngine">
    <div class="content animate-panel">
        <div class="row">
            <div class="col-lg-4">
                <div class="hpanel">
                    <div class="panel-heading">
                        <div class="panel-tools">
                            <a class="showhide"><i class="fa fa-chevron-up"></i></a>
                        </div>
                        Identification
                    </div>
                    <div class="panel-body">
                        <div class="form-horizontal">
                            <div class="form-group">
                                <label class="col-lg-4 control-label">S/N IMEI</label>
                                <div class="col-lg-8"><p class="form-control-static"><?php echo get_value("ident_IMEI") ?></p></div>
                            </div>
                            <div class="form-group">
                                <label class="col-lg-4 control-label">SIM ICCID</label>
                                <div class="col-lg-8"><p class="form-control-static"><?php echo get_value("ident_ICCID") ?></p></div>
                            </div>
                            <div class="form-group" ng-controller="myInput" ng-init="init('ident_HostName')">
                                <label class="col-lg-4 control-label">Host Name</label>
                                <div class="col-lg-8" ng-hide="editable">
                                    <div class="input-group m-b">
                                      <p class="form-control-static">{{value}}</p>
                                      <button type="button" class="btn btn-outline btn-primary btn-xs" ng-click="edit()" ng-hide="editable">Edit</button>
                                    </div>
                                </div>
                                <div class="col-lg-8" ng-show="editable">
                                    <div class="input-group m-b">
                                        <input type="text" maxlength="32" class="form-control" ng-model="value">
                                    </div>
                                    <button type="button" class="btn btn-outline btn-warning btn-xs" style="margin-right:5px" ng-click="save()">Save</button>
                                    <button type="button" class="btn btn-outline btn-danger btn-xs" ng-click="cancel()">Cancel</button>
                                </div>
                            </div>
                            <div class="form-group" ng-controller="myInput" ng-init="init('ident_Contact')">
                                <label class="col-lg-4 control-label">Contact</label>
                                <div class="col-lg-8" ng-hide="editable">
                                    <div class="input-group m-b">
                                      <p class="form-control-static">{{value}}</p>
                                      <button type="button" class="btn btn-outline btn-primary btn-xs" ng-click="edit()" ng-hide="editable">Edit</button>
                                    </div>
                                </div>
                                <div class="col-lg-8" ng-show="editable">
                                    <div class="input-group m-b">
                                        <input type="text" maxlength="32" class="form-control" ng-model="value">
                                    </div>
                                    <button type="button" class="btn btn-outline btn-warning btn-xs" style="margin-right:5px" ng-click="save()">Save</button>
                                    <button type="button" class="btn btn-outline btn-danger btn-xs" ng-click="cancel()">Cancel</button>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-lg-4 control-label">Order ID</label>
                                <div class="col-lg-8"><p class="form-control-static"><?php echo get_value("ident_OrderID") ?></p></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="hpanel">
                    <div class="panel-heading">
                        <div class="panel-tools">
                            <a class="showhide"><i class="fa fa-chevron-up"></i></a>
                        </div>
                        Version
                    </div>
                    <div class="panel-body">
                        <div class="form-horizontal">
                            <div class="form-group">
                                <label class="col-lg-4 control-label">Engine</label>
                                <div class="col-lg-8"><p class="form-control-static"><?php echo get_value("version_Engine") ?></p></div>
                            </div>
                            <div class="form-group">
                                <label class="col-lg-4 control-label">Kernel</label>
                                <div class="col-lg-8"><p class="form-control-static"><?php echo get_value("version_Kernel") ?></p></div>
                            </div>
                            <div class="form-group">
                                <label class="col-lg-4 control-label">R-Loader md5</label>
                                <div class="col-lg-8"><p class="form-control-static"><?php echo get_value("version_RLoader") ?></p></div>
                            </div>
                            <div class="form-group">
                                <label class="col-lg-4 control-label">Modem</label>
                                <div class="col-lg-8"><p class="form-control-static"><?php echo get_value("version_ModemFW") ?></p></div>
                            </div>
                            <div class="form-group">
                                <label class="col-lg-4 control-label">Microchip</label>
                                <div class="col-lg-8"><p class="form-control-static"><?php echo get_value("version_MicrochipFW") ?></p></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="hpanel">
                    <div class="panel-heading">
                        <div class="panel-tools">
                            <a class="showhide"><i class="fa fa-chevron-up"></i></a>
                        </div>
                        System Info
                    </div>
                    <div class="panel-body">
                        <div class="form-horizontal">
                          <div class="form-group">
                              <label class="col-lg-4 control-label">Uptime</label>
                              <div class="col-lg-8"><p class="form-control-static"><?php echo get_value("system_Uptime") ?></p></div>
                          </div>
                          <div class="form-group">
                              <label class="col-lg-4 control-label">Load average</label>
                              <div class="col-lg-8"><p class="form-control-static"><?php echo get_value("system_Load") ?></p></div>
                          </div>
                          <div class="form-group">
                              <label class="col-lg-4 control-label">RAM usage</label>
                              <div class="col-lg-8"><p class="form-control-static"><?php echo get_value("system_RAM") ?></p></div>
                          </div>

                          <button type="button" class="btn btn-block btn-outline btn-default" ng-controller="getTextButton" ng-init="init('information_export')" ng-click="click()" ng-disabled="loading">
                              <div ng-hide="loading">
                                  <img src="icons/ExportConfig.png" alt="Export Information" height="30" width="30"></br>Export Information
                              </div>
                              <div ng-show="loading">
                                  <span><i class="glyphicon glyphicon-refresh spinning"></i></span></br>Loading ...
                              </div>
                          </button>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include("shared/footer.php");?>

</div>

<?php include("shared/scripts.php");?>

</body>
</html>
