<!DOCTYPE html>
<?php
$page_name = "Logging";
?>
<html>
<head>
    <?php include("shared/head.php");?>
    <!-- Page title -->
    <title>Web Engine - <?php echo $page_name?></title>
</head>
<body>

<!-- Simple splash screen-->
<div class="splash"> <div class="color-line"></div></div>
<!--[if lt IE 7]>
<p class="alert alert-danger">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
<![endif]-->

<!-- Header -->
<div id="header">
    <?php include("shared/header.php");?>
</div>

<!-- Navigation -->
<aside id="menu">
    <?php include("shared/menu.php");?>
</aside>

<!-- Main Wrapper -->
<div id="wrapper" ng-app="WebEngine">
    <div class="content animate-panel">
        <div class="row">
            <div class="col-lg-6">
                <div class="hpanel">
                    <div class="panel-heading">
                        <div class="panel-tools">
                            <a class="showhide"><i class="fa fa-chevron-up"></i></a>
                        </div>
                        Configuration
                    </div>
                    <div class="panel-body">
                        <div class="form-horizontal">
                            <div class="form-group" ng-controller="checkbox" ng-init="init('log_Active')" >
                                <label class="col-lg-4 control-label">Logging enabled</label>
                                <div class="col-lg-8">
                                    <input class="form-check-input" type="checkbox" ng-model="checked" ng-change="change()">
                                </div>
                            </div>
                            <div class="form-group" ng-controller="myInput" ng-init="init('log_LogInterval',true)">
                                <label class="col-lg-4 control-label">Loggging Interval</label>
                                <div class="col-lg-8" ng-hide="editable">
                                    <div class="input-group m-b">
                                      <p class="form-control-static">{{value}} minutes</p>
                                      <button type="button" class="btn btn-outline btn-primary btn-xs" ng-click="edit()" ng-hide="editable">Edit</button>
                                    </div>
                                </div>
                                <div class="col-lg-8" ng-show="editable">
                                    <div class="input-group m-b">
                                        <input type="number" min="1" class="form-control" ng-model="value"> <span class="input-group-addon">minutes</span>
                                    </div>
                                    <button type="button" class="btn btn-outline btn-warning btn-xs" style="margin-right:5px" ng-click="save()">Save</button>
                                    <button type="button" class="btn btn-outline btn-danger btn-xs" ng-click="cancel()">Cancel</button>
                                </div>
                            </div>
                            <div class="form-group" ng-controller="myInput" ng-init="init('log_XferInterval',true)">
                                <label class="col-lg-4 control-label">Transfer Interval</label>
                                <div class="col-lg-8" ng-hide="editable">
                                    <div class="input-group m-b">
                                      <p class="form-control-static">{{value}} minutes</p>
                                      <button type="button" class="btn btn-outline btn-primary btn-xs" ng-click="edit()" ng-hide="editable">Edit</button>
                                    </div>
                                </div>
                                <div class="col-lg-8" ng-show="editable">
                                    <div class="input-group m-b">
                                        <input type="number" min="1" class="form-control" ng-model="value"> <span class="input-group-addon">minutes</span>
                                    </div>
                                    <button type="button" class="btn btn-outline btn-warning btn-xs" style="margin-right:5px" ng-click="save()">Save</button>
                                    <button type="button" class="btn btn-outline btn-danger btn-xs" ng-click="cancel()">Cancel</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="hpanel">
                    <div class="panel-heading">
                        <div class="panel-tools">
                            <a class="showhide"><i class="fa fa-chevron-up"></i></a>
                        </div>
                        Export
                    </div>
                    <div class="panel-body" ng-controller="myRadioboxCtrl">
                        <div class="form-horizontal">
                          <div class="form-group">
                              <label class="col-sm-4 control-label">Chose the log files to export:</label>
                              <div class="col-sm-8">
                                  <div class="radio"><label> <input type="radio" id="cb_0" name="cb" value="0" ng-model="value"> Log files for the last 24 hours</label></div>
                                  <div class="radio"><label> <input type="radio" id="cb_1" name="cb" value="1" ng-model="value" checked> Log files for the last 7 days</label></div>
                                  <div class="radio"><label> <input type="radio" id="cb_2" name="cb" value="2" ng-model="value"> Log files for the last 30 days</label></div>
                                  <div class="radio"><label> <input type="radio" id="cb_3" name="cb" value="3" ng-model="value"> All log files</label></div>
                              </div>
                          </div>
                          <button type="button" class="btn btn-block btn-outline btn-default" ng-click="click()" ng-disabled="loading">
                              <div ng-hide="loading">
                                  <img src="icons/log_export.png" alt="Export Log files" height="30" width="30"></br>Export Log files
                              </div>
                              <div ng-show="loading">
                                  <span><i class="glyphicon glyphicon-refresh spinning"></i></span></br>Loading ...
                              </div>
                          </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include("shared/footer.php");?>

</div>

<?php include("shared/scripts.php");?>

</body>
</html>
